/*
 * Decompiled with CFR 0.152.
 */
package adql.db.exception;

import adql.parser.ParseException;
import adql.query.operand.function.ADQLFunction;

public class UnresolvedFunctionException
extends ParseException {
    private static final long serialVersionUID = 1L;
    protected final ADQLFunction functionInError;

    public UnresolvedFunctionException(String string) {
        super(string);
        this.functionInError = null;
    }

    public UnresolvedFunctionException(ADQLFunction aDQLFunction) {
        super("Unresolved function: \"" + aDQLFunction.toADQL() + "\"! No UDF has been defined or found with the signature: " + UnresolvedFunctionException.getFctSignature(aDQLFunction) + ".");
        this.functionInError = aDQLFunction;
    }

    public UnresolvedFunctionException(String string, ADQLFunction aDQLFunction) {
        super(string);
        this.functionInError = aDQLFunction;
    }

    public final ADQLFunction getFunction() {
        return this.functionInError;
    }

    public static String getFctSignature(ADQLFunction aDQLFunction) {
        if (aDQLFunction == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(aDQLFunction.getName().toLowerCase());
        stringBuffer.append('(');
        for (int i = 0; i < aDQLFunction.getNbParameters(); ++i) {
            if (aDQLFunction.getParameter(i).isNumeric()) {
                stringBuffer.append("NUMERIC");
            } else if (aDQLFunction.getParameter(i).isString()) {
                stringBuffer.append("STRING");
            } else if (aDQLFunction.getParameter(i).isGeometry()) {
                stringBuffer.append("GEOMETRY");
            } else {
                stringBuffer.append("???");
            }
            if (i + 1 >= aDQLFunction.getNbParameters()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

